local _,L = ...

if GetLocale()=="zhCN" then

-- New strings in 4.7.3
	L["Shared Moveset"] = "公有技能组合"
	L["In addition to the flyouts, show the numbers 1 and 2 on loaded abilities."] = "除了下拉框之外，在已选择的技能上也显示数字 1 和 2"
	L["When a team auto loads, show the Rematch window if any pets in the team are injured."] = "自动加载队伍时，如果队伍中有宠物受伤，则显示 Rematch 窗口。"
	L["Only list pets that can battle. Do not list pets like balloons, squires and other companion pets that cannot battle."] = "只显示可以战斗的宠物。不显示气球、侍从和其它银白冠军联赛的无法战斗的宠物。"
	L["Moveset"] = "技能组合"
	L["Unique Moveset"] = "独特技能组合"
	L["This will export all teams across all tabs into text that you can paste elsewhere, such as an email to yourself or a text file someplace safe. You can later restore these teams with the Import Teams option."] = "导出所有标签的所有队伍为纯文本格式，你可以把它复制到任何地方，比如给自己发送邮件或者用文本文件保存在安全的地方。随后你可以用导入队伍功能恢复这些队伍。"
	L["Hide Non-Battle Pets"] = "隐藏非战斗宠物"
	L["Find Moveset"] = "查找技能组合"

-- New strings in 4.7.1
	L["For random pets, randomize the pets' abilities also."] = "随机选择宠物时，同时随机选择宠物技能。"
	L["Random %s"] = "随机%s"
	L["This pet is already in the queue and Active Sort is enabled.\n\nWhile enabled, the queue has complete control over the order of pets in the queue.\n\nDo you want to turn off Active Sort to move this pet in the queue?"] = "这个宠物已经在升级队列里，并且启用了主动排序。\n\n启用时，宠物的排序完全由队列控制。\n\n是否停用主动排序来移动宠物在升级队列里的排序。"
	L["Ignored Pet"] = "已忽略的宠物"
	L["Unknown"] = "未知"
	L["Loaded Team"] = "已加载的队伍"
	L["Randomize Abilities Too"] = "同时随机选择技能"
	L["Current Leveling Pet"] = "当前正在升级的宠物"

-- New strings in 4.7.0
	L["Any Type"] = "任何类型"
	L["When this team loads, this spot will be ignored."] = "加载这个队伍时，这个栏位会被忽略。"
	L["Leveling Slot"] = "升级栏位"
	L["This slot is controlled by the leveling queue.\n\nTeams saved with leveling slots will load leveling pets from the queue into these slots."] = "这个栏位将由升级队列控制。\n\n包含升级栏位的队伍，会把队列中需要升级的宠物加载到这些栏位中。"
	L["Random Pet"] = "随机宠物"
	L["When this team loads, a random high level pet will go in this spot."] = "加载这个队伍时，一个随机的高等级宠物会被放在这个栏位。"
	L["Deadmines"] = "死亡矿井"
	L["Ignored Slot"] = "忽略栏位"
	L["Ignore This Slot"] = "忽略这个栏位"
	L["These variables are defined as the script runs for each pet:\n\n\124cffffd200owned\124r \124cffaaaaaa(boolean)\124r\nWhether the pet is owned by the player.\n\n\124cffffd200petID\124r \124cffaaaaaa(string)\124r\nUnique ID of the owned pet, such as \"BattlePet-0-000004A98F18\".\n\n\124cffffd200speciesID\124r \124cffaaaaaa(number)\124r\nShared ID of the pet's family. Black Tabby Cats are species 42.\n\n\124cffffd200customName\124r \124cffaaaaaa(string)\124r\nName given to the pet by the player.\n\n\124cffffd200level\124r \124cffaaaaaa(number)\124r\nLevel of the pet, or nil for uncollected pets.\n\n\124cffffd200xp\124r \124cffaaaaaa(number)\124r\nAmount of xp the pet has in its current level.\n\n\124cffffd200maxXp\124r \124cffaaaaaa(number)\124r\nTotal amount of xp required to reach the pet's next level.\n\n\124cffffd200displayID\124r \124cffaaaaaa(number)\124r\nA numeric representation of a pet's model skin.\n\n\124cffffd200isFavorite\124r \124cffaaaaaa(boolean)\124r\nWhether the pet is favorited by the player.\n\n\124cffffd200name\124r \124cffaaaaaa(string)\124r\nTrue name of the pet species.\n\n\124cffffd200icon\124r \124cffaaaaaa(string)\124r\nTexture path of the pet's icon.\n\n\124cffffd200petType\124r \124cffaaaaaa(number)\124r\nValue between 1 and 10 for its type. 1=Humanoid, 2=Dragonkin, etc.\n\n\124cffffd200creatureID\124r \124cffaaaaaa(number)\124r\nThe npcID of the pet when it's summoned.\n\n\124cffffd200sourceText\124r \124cffaaaaaa(string)\124r\nFormatted text describing where the pet is from.\n\n\124cffffd200description\124r \124cffaaaaaa(string)\124r\nLore text of the species.\n\n\124cffffd200isWild\124r \124cffaaaaaa(boolean)\124r\nWhether the pet was a captured wild pet.\n\n\124cffffd200canBattle\124r \124cffaaaaaa(boolean)\124r\nWhether the pet can battle.\n\n\124cffffd200tradable\124r \124cffaaaaaa(boolean)\124r\nWhether the pet can be caged.\n\n\124cffffd200unique\124r \124cffaaaaaa(boolean)\124r\nWhether no more than one of the pet can be known at a time.\n\n\124cffffd200abilityList\124r \124cffaaaaaa(table)\124r\nArray of abilityIDs used by the species.\n\n\124cffffd200levelList\124r \124cffaaaaaa(table)\124r\nArray of levels the abilityIDs are learned.\n\nFurther information about pets can be retrieved with the \124cffffd200petInfo\124r system. See Process\\PetInfo.lua for more information."] = "这些变量被定义作为脚本来循环遍历宠物:\n\n\124cffffd200owned\124r \124cffaaaaaa(boolean)\124r\n玩家是否拥有这个宠物。\n\n\124cffffd200petID\124r \124cffaaaaaa(string)\124r\n宠物的唯一 ID，例如 \"BattlePet-0-000004A98F18\".\n\n\124cffffd200speciesID\124r \124cffaaaaaa(number)\124r\n该类宠物的公用 ID. 黑纹灰猫的 species ID 是 42。\n\n\124cffffd200customName\124r \124cffaaaaaa(string)\124r\n玩家给宠物起的名字。\n\n\124cffffd200level\124r \124cffaaaaaa(number)\124r\n宠物的等级，如果是未收集的宠物，则为空 (nil).\n\n\124cffffd200xp\124r \124cffaaaaaa(number)\124r\n宠物在当前等级所拥有的经验总值。\n\n\124cffffd200maxXp\124r \124cffaaaaaa(number)\124r\n升到下一级所需要的经验。\n\n\124cffffd200displayID\124r \124cffaaaaaa(number)\124r\n一个用于代表宠物的模型外观的数字。\n\n\124cffffd200isFavorite\124r \124cffaaaaaa(boolean)\124r\n玩家是否为该宠物设置了偏好。\n\n\124cffffd200name\124r \124cffaaaaaa(string)\124r\n宠物物种的真实名字。\n\n\124cffffd200icon\124r \124cffaaaaaa(string)\124r\n宠物图标的纹理路径。\n\n\124cffffd200petType\124r \124cffaaaaaa(number)\124r\n值的范围是1到10，1=人型生物，2=龙类，等等。\n\n\124cffffd200creatureID\124r \124cffaaaaaa(number)\124r\n宠物被召唤时，它的npcID。\n\n\124cffffd200sourceText\124r \124cffaaaaaa(string)\124r\n宠物来源。\n\n\124cffffd200description\124r \124cffaaaaaa(string)\124r\n该物种的故事背景。\n\n\124cffffd200isWild\124r \124cffaaaaaa(boolean)\124r\n该宠物是否是一个已经被捕获的野生宠物。\n\n\124cffffd200canBattle\124r \124cffaaaaaa(boolean)\124r\n该宠物是否可以战斗。\n\n\124cffffd200tradable\124r \124cffaaaaaa(boolean)\124r\n该宠物是否可以装笼交易。\n\n\124cffffd200unique\124r \124cffaaaaaa(boolean)\124r\n该宠物是否一次只能获取一个。\n\n\124cffffd200abilityList\124r \124cffaaaaaa(table)\124r\n用于该物种的 abilityID 的数组。\n\n\124cffffd200levelList\124r \124cffaaaaaa(table)\124r\n所有等级学会的 abilityID 的数组。\n\n关于宠物的更多信息可以查询\124cffffd200petInfo\124r 系统。参考 Process\\PetInfo.lua 获取更多信息。"
	L["Put Random Pet Here"] = "在此放置随机宠物"
	L["Teams saved with random slots will load a random high level pet into these slots."] = "含有随机栏位的队伍会加载随机的高等级宠物到此栏位。"
	L["Stop Ignoring This Slot"] = "不再忽略这个栏位"
	L["Stop Randomizing This Slot"] = "不再随机这个栏位"
	L["Teams saved with ignored slots will not load anything into these slots."] = "含有忽略栏位的队伍不会加载任何宠物到此栏位。"
	L["Random %s Pet"] = "随机%s宠物"

-- New strings in 4.6.8
	L["Export this team as a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can paste this team into their Rematch via Import Team."] = "将这个队伍导出为字符串，以便复制到其他地方，例如论坛和邮件。\n\n其他使用 Rematch 的玩家可以使用导入队伍的功能，粘贴导入这个队伍。"
	L["Format this team into plain text to copy elsewhere, such as forums or emails.\n\nThe plain text format is best for sharing a team with others that may not use Rematch."] = "将这个队伍格式化为纯文本，以便复制到其他地方，例如论坛和邮件。\n\n纯文本格式是和未使用 Rematch 的玩家分享队伍的最佳方式。"
	L["Wailing Caverns"] = "哀嚎洞穴"
	L["Share In Legacy Format"] = "使用传统格式共享"
	L["Prioritize Breed On Import"] = "导入时优先品种数据"
	L["Note: These are just your teams and their notes and preferences. Tab information, sort orders, win records and other settings are not included.\n\nFor the most complete backup of all your addon data, please backup your Word of Warcraft\\WTF folder."] = "注意: 这里只会备份队伍、备注和偏好设置。不包括标签信息、排序、胜场记录和其他设置。\n\n为了完整备份插件数据，请备份你的 Word of Warcraft\\WTF 文件夹。"
	L["When exporting teams or sending to another Rematch user, use the old format.\n\nUse this option when sharing teams with someone on an older Rematch that's unable to import or receive newer teams."] = "导出队伍或发送队伍给其他 Rematch 用户时，使用原来的旧格式。\n\n旧版本的 Rematch 无法导出或导入新的队伍，给使用旧版本的 Rematch 用户分享队伍时，需要使用这个选项。"
	L["%sWARNING!\124r This will %sPERMANENTLY DELETE\124r all teams in this tab!"] = "%s警告！\124r 这将会%s永久删除\124r该标签内的所有队伍！"
	L["Delete teams within the tab too"] = "删除标签内的队伍"
	L["When importing or receiving teams, fill the team with the best matched breed as the first priority instead of the highest level."] = "当导入或接收队伍时，优先使用品种匹配的宠物，而不是最高等级的宠物。"
	L["Broken Isle"] = "破碎海滩"
	L["Import a single team or many teams that were exported from Rematch."] = "导入来自 Rematch 的单个或多个队伍。"
	L["Copy As Plain Text"] = "复制为纯文本"
	
-- New strings in 4.6.2
	L["A New Pet!"] = "新宠物！"
	L["%s\n\n%sWARNING!\124r There may be an issue with pet toasts in ElvUI not positioning properly. While using ElvUI it's recommended pet toasts remain hidden unless you've moved alerts in ElvUI."] = "%s\n\n%s警告!\124r ElvUI 中可能会存在宠物对话框位置不正确的问题。使用 ElvUI 时推荐将宠物对话框隐藏，除非你已经在 ElvUI 中移动了弹出框的位置。"

-- New strings in 4.6.1
	L["Only Load This Team"] = "仅加载这个队伍"
	L["Imported Team"] = "已导入队伍"
	L["This will only load the team and not save it.\n\nThis is for loading teams you do not intend to use more than once, like Family Familiar teams."] = "仅加载这个队伍而不保存它。\n\n该功能用于加载那些你只打算用一次的队伍，比如队伍成员类似的队伍。"

-- New strings in 4.6.0
	L["This allows you to create custom pet filters with a little bit of Lua code. See the reference buttons at the top of the New Script dialog for details.\n\nTo view or edit an existing script, click the Gear icon beside the script in the menu above."] = "你可以用 Lua 代码创建自己的宠物筛选器。 详情请点击 “新建脚本” 窗口顶部的各个参考选项。\n\n要查看或编辑一个脚本，点击脚本旁边的齿轮图标。"
	L["Or With Panel Tabs"] = "或者点击选择面板标签时"
	L["Group favorites to the top of the queue."] = "偏好宠物排到队列顶部"
	L["When a team loads, if any pet is injured or dead and there's another version with more health \124cffffffffand identical stats\124r, load the healthier version.\n\nPets in the leveling queue are exempt from this option.\n\n\124cffffffffNote:\124r This is only when a team loads. It will not automatically swap in healthier pets when you leave battle."] = "加载一个队伍时，如果有任何宠物受伤或死亡，同时该宠物有另一只的血量更高\124cffffffff并且属相相同\124r, 加载血量更高的那一只。\n\n升级队列中的宠物不受该选项影响。\n\n\124cffffffffNote:\124r 该选项只在加载队伍时生效，当你结束宠物对战时，不会自动替换血量更高的宠物。"
	L["Do nothing when pets within Rematch are double-clicked. The normal behavior of double click throughout Rematch is to summon or dismiss the pet."] = "忽略对宠物的双击操作。双击宠物的默认行为是召唤或解散宠物。"
	L["Load Healthiest Pets"] = "加载血量最高的宠物"
	L["The script environment is restricted with access to only common Lua and the following:\n\n\124cffffd200C_PetJournal \124cffaaaaaa(table)\124r\nThe default API for journal functions.\n\n\124cffffd200C_PetBattles \124cffaaaaaa(table)\124r\nThe default API for the battle UI.\n\n\124cffffd200GetBreed \124cffaaaaaa(function)\nArgument:\124r petID\n\124cffaaaaaaReturns:\124r The numeric breed (3-12) of a petID if one of the supported breed addons is enabled.\n\n\124cffffd200GetSource \124cffaaaaaa(function)\nArgument:\124r speciesID\n\124cffaaaaaaReturns:\124r The numeric source (1-10) of a speciesID. 1=Drop, 2=Quest, etc.\n\n\124cffffd200IsPetLeveling \124cffaaaaaa(function)\nArgument:\124r petID\n\124cffaaaaaaReturns:\124r Whether the given petID is in the leveling queue.\n\nA few iterator functions are also provided if you need to compare a pet against others. These are used in a for loop such as:\n\n\124cffcccccc    for speciesID in \124cffffd200AllSpeciesIDs()\124cffcccccc do\n      -- do something with speciesID\n    end\124r\n\n\124cffffd200AllSpeciesIDs \124cffaaaaaa(iterator function)\nReturns:\124r The next speciesID of all existing unique pets.\n\n\124cffffd200AllPetIDs \124cffaaaaaa(iterator function)\nReturns:\124r The next petID of all owned pets.\n\n\124cffffd200AllPets \124cffaaaaaa(iterator function)\nReturns:\124r The next petID or speciesID of all pets in the master list. Owned pets return a petID string, uncollected pets return a speciesID number.\n\n\124cffffd200AllAbilities \124cffaaaaaa(iterator function)\nArgument:\124r speciesID\n\124cffaaaaaaReturns:\124r The next abilityID and level of the ability for a speciesID.\n\124cffffd200Note:\124r abilityList and levelList are already defined for each pet as your script runs. Use this iterator if you need to gather abilities of other pets for comparison. See the Unique Abilities script for an example.\n\n\124cffffd200If you would like anything else exposed please post a comment on wowinterface, curse or warcraftpet's Rematch 4.0 thread."] = "脚本环境被限定于通用 Lua 语言，还有下列：\n\n\124cffffd200C_PetJournal \124cffaaaaaa(table)\124r\n日志功能的默认API。\n\n\124cffffd200C_PetBattles \124cffaaaaaa(table)\124r\n战斗UI的默认API。\n\n\124cffffd200GetBreed \124cffaaaaaa(function)\n参数：\124r petID\n\124cffaaaaaa返回值：\124r 如果启用了支持品种的插件，返回值是petID的品种值 (3-12)\n\n\124cffffd200GetSource \124cffaaaaaa(function)\n参数：\124r speciesID\n\124cffaaaaaa返回值：\124r speciesID 的来源值(1-10)，1=掉落, 2=任务, 等等。\n\n\124cffffd200IsPetLeveling \124cffaaaaaa(function)\n参数:\124r petID\n\124cffaaaaaa返回值：\124r 指定的 petID 是否在升级队列中。\n\n如果需要对比宠物，可以使用 for 循环，例如：\n\n\124cffcccccc    for speciesID in \124cffffd200AllSpeciesIDs()\124cffcccccc do\n      -- 根据 speciesID 做些什么操作\n    end\124r\n\n\124cffffd200AllSpeciesIDs \124cffaaaaaa(iterator function)\n返回值：\124r 所有存在且唯一的宠物的下一个speciesID。\n\n\124cffffd200AllPetIDs \124cffaaaaaa(iterator function)\n返回值：\124r 所有宠物的下一个 petID。\n\n\124cffffd200AllPets \124cffaaaaaa(iterator function)\n返回值：\124r 主列表中所有宠物的下一个petID或speciesID。拥有的宠物返回 petID 字符串，未收集的宠物返回 speciesID 数值.\n\n\124cffffd200AllAbilities \124cffaaaaaa(iterator function)\n参数：\124r speciesID\n\124cffaaaaaa返回值：\124r 下一个 abilityID 和 某一 speciesID 的技能等级。\n\124cffffd200注意：\124r abilityList 和 levelList 已经被定义为你可以运行的遍历宠物的脚本。如果你需要获取其它宠物的技能用于比较，那么就使用这个迭代器。参考 唯一技能脚本 (Unique Abilities script) 作为例子。\n\n\124cffffd200如果你想获取其它任何的公开PAI，请在 wowinterface，curse 或者 warcraftpet 的 Rematch 4.0 帖子上留言。"
	L["\124cffffd200-\124r Scripts are a way to create custom pet filters.\n\n\124cffffd200-\124r Scripts are Lua code and require some knowledge of the language and API to create your own filters.\n\n\124cffffd200-\124r Scripts run for each pet and should return true if the pet is to be listed.\n\n\124cffffd200-\124r Some variables are filled in as the script runs for each pet. See Pet Variables.\n\n\124cffffd200-\124r Scripts run in a restricted environment with no access outside its environment. See Exposed API.\n\n\124cffffd200-\124r All variables/tables created exist only in this environment and disappear when the filter finishes.\n\n\124cffffd200-\124r If the first line of the script is a --comment, it will be used as a tooltip in the Script menu."] = "\124cffffd200-\124r 脚本用于创建宠物筛选器。\n\n\124cffffd200-\124r 此处所说的脚本是指 Lua 代码，想要编写你自己的筛选器，需要对这门语言和 API 有所了解。\n\n\124cffffd200-\124r 脚本循环遍历每个宠物，如果查询到某个宠物，返回 true。\n\n\124cffffd200-\124r 有些变量可以被用于脚本中，用以遍历所有宠物。参考 宠物变量 (Pet Variables).\n\n\124cffffd200-\124r 脚本运行在一个限定的环境里，无法访问该环境之外的内容。 参考 公开API。\n\n\124cffffd200-\124r 创建的所有的变量/表只存在与这个环境变量里，在筛选器运行完成后即被释放。\n\n\124cffffd200-\124r 如果脚本的第一行是 --注释, 它会被作为一个鼠标提示，用于脚本菜单中。"
	L["Don't let the Pets, Teams, Queue or Options tabs minimize the standalone window."] = "不要让宠物、队伍、队列或选项的面板标签最小化独立窗口"
	L["On Loaded Abilities Too"] = "显示在选中的技能上"
	L["Group rares to the top of the leveling queue."] = "稀有宠物排到队列顶部"
	L["No Summon On Double Click"] = "双击时不召唤宠物"
	L["Rares First"] = "稀有优先"
	L["Script Filters"] = "脚本筛选器"

-- New strings in 4.5.0
	L["This is the leveling queue. Drag pets you want to level here.\n\nRight click any of the three battle pet slots and choose 'Put Leveling Pet Here' to mark it as a leveling slot you want controlled by the queue.\n\nWhile a leveling slot is active, the queue will fill the slot with the top-most pet in the queue. When this pet reaches level 25 (gratz!) it will leave the queue and the next pet in the queue will take its place.\n\nTeams saved with a leveling slot will reserve that slot for future leveling pets."] = "这里是升级队列。把想要升级的宠物拖放到这里。\n\n右键点击三个战斗宠物栏位中的任意一个，选择 “将要升级的宠物放在这个栏位”，将该栏位设置为升级栏位，设置后的升级栏位将由升级队列控制。\n\n当一个升级栏位被激活后，升级队列会用位于队列最顶端的宠物填充这个栏位。当宠物升至25级(赞！)，它就会离开升级队列，队列中的下一个宠物会取代它的位置。\n\n队伍保存时包含升级栏位的，这个栏位会被预留，用于升级其它宠物。"
	L["Don't show a popup offering to backup teams every once in a while. Generally, the popup appears sometime after the number of teams increases by 50."] = "不要在备份队伍时弹出提示。一般情况下，队伍数量每增加50个，备份时就会弹出提示。"
	L["Backup All Rematch Teams?"] = "备份所有队伍？"
	L["Don't Remind About Backups"] = "备份时不提示"
	L["Choosing Yes will export all teams to copy and paste in an email to yourself or someplace safe.\n\nYou can also do this at any time from the Teams button at the top of the Teams panel of Rematch."] = "选择 “是” 将会导出所有队伍，以便复制粘贴到电子邮件里发给自己，或其它安全的地方。\n\n用队伍界面顶端的“队伍”按钮，你可以随时导出你的队伍。"
	L["Leveling Queue"] = "升级队列"
	L["You have %s%d\124r Rematch teams.\n\nWould you like to back them up?"] = "你有 %s%d\124r 个队伍。\n\n要备份它们吗？"
	L["Confirmation Options"] = "确认选项"
	L["Stop Leveling This Slot"] = "取消这个升级栏位"

-- New strings in 4.4.9
	L["Stats Search"] = "指标搜索"

-- New strings in 4.4.7
	L["Don't Sort By Relevance"] = "禁用相关性排序"
	L["When searching for something by name in the search box, do not sort the results by relevance.\n\nWhen sorted by relevance, pets with the search term in their name are listed first, followed by terms in notes, then abilities and then source text last."] = "在搜索框中按名字搜索时，不要按相关性排序。\n\n按相关性排序时，宠物名字与搜索内容相匹配的会被排在首位，其次是备注、技能、宠物来源。"
	L["In addition to the filters in this menu, you can further refine the pet list with the search box. Some search examples:\n\nPets: %sBlack Tabby\124r\nZones: %sSilithus\124r\nAbilities: %sSandstorm\124r\nText in abilities: %sBleed\124r\nLevels: %slevel=21-23\124r\nStats: %sspeed>300\124r\n\nSearches in \"quotes\" will limit results to only complete matches.\n\nSearch results will be sorted by relevance unless the option %sDon't Sort By Relevance\124r is checked in the Options tab."] = "除了菜单中的筛选方式之外，还可以使用搜索框来进一步细化宠物列表。这里列出一些搜索范例: \n\n按宠物名字搜索: %s黑纹灰猫\124r\n按地区搜索: %s希利苏斯\124r\n按技能搜索: %s沙尘暴\124r\n按技能中的文字搜索: %s流血\124r\n按等级搜索: %slevel=21-23 (表示21-23级)\124r\n按属性搜索: %sspeed>300 (表示速度大于300)\124r\n\n搜索内容加引号 \"搜索内容\"，会仅显示完全匹配的搜索结果。\n\n搜索结果会按相关性排序，除非勾选了选项里的%s禁用相关性排序\124r。"
	L["Val'sharah"] = "瓦尔沙拉"
	L["Suramar"] = "苏拉玛"
	L["Stormheim"] = "风暴峡湾"
	L["Highmountain"] = "至高岭"
	L["Dalaran"] = "达拉然"
	L["Azsuna"] = "阿苏纳"

-- New strings in 4.4.6
	L["About Teams"] = "关于队伍"
	L["Teams named in %sWhite\124r have a target stored within them.\nTeams named in Gold do not.\n\n%sTo change pets or abilities in a team:\124r\n1) Load the team.\n2) Make any changes.\n3) Click Save at the bottom of the window."] = "队伍名是%s白色，\124r 表示该队伍有对应的目标。\n队伍名是金色，表示没有对应的目标。\n\n%s要更换队伍中的宠物或技能：\124r\n1) 加载该队伍\n2) 做出改动\n3) 点击窗口底部的保存按钮"

-- Main.lua
	L["Rematch"] = "Rematch 宠物战队"
	L["Toggle Window"] = "开启/关闭窗口"
	L["Auto Load"] = "自动加载队伍"
	L["Team Notes"] = "队伍备注"
	L["Pets Tab"] = "宠物标签页"
	L["Teams Tab"] = "队伍标签页"
	L["Queue Tab"] = "升级队列标签页"
	L["Toggle Rematch"] = "开启/关闭 Rematch"
	L["Load this team?"] = "是否加载这个队伍?"
	L["They do not appear to be online."] = "他们似乎不在线上"
	L["has also been added to your leveling queue!"] = "已经加入升级队列!"
	L["The team named '%s' can't be found."] = "无法找到名为 '%s' 的队伍"
	L["Rematch Debug Info"] = "Rematch 调试信息"

-- Utils.lua
	L["Leveling Pet"] = "升级宠物"

-- Widgets\PetListButtons.lua
	L["Empty Battle Pet Slot"] = "清空战斗栏位"
	L["This pet can't level."] = "这个宠物无法升级"
	L["Only pets that can battle and are under 25 can go in the leveling queue."] = "只有25级以下并且可以战斗的宠物，才能加入升级队列"

-- Widgets\Toolbar.lua
	L["Total Pets"] = "宠物总数"
	L["Unique Pets"] = "独特宠物"
	L["Save As..."] = "另存为..."
	L["Save the currently loaded pets to a new team."] = "将目前加载的宠物保存为新的队伍"
	L["Save the currently loaded pets to the loaded team."] = "将目前加载的宠物保存至已加载的队伍"
	L["Dismiss Pet"] = "解散宠物"
	L["Summon Pet"] = "召唤宠物"
	L["Summons a random pet from your favorites."] = "从偏好中随机召唤宠物"
	L["Random Favorite"] = "随机偏好"
	L["Random From All"] = "随机全部"
	L["All pets are at full health."] = "所有宠物的生命值都已回满"
	L["This treat's buff is already active."] = "治疗 Buff 已经启用"
	L["%s\n\nPets At Max Level: %s%d\124r\nPets Not Collected: %s%d\124r\n\n%s Click to display more about your collection."] = "%s\n\n等级已满宠物: %s%d\124r\n尚未收集宠物: %s%d\124r\n\n%s 点击显示更多收藏"

	-- Widgets\MinimapButton.lua
	L["Load Favorite Team"] = "加载偏好队伍"
	L["Favorite Teams"] = "偏好队伍"

-- Widgets\PanelTabs.lua

-- Process\PetLoading.lua
	L["You can't load a team during combat."] = "无法在战斗中加载队伍"
	L["You can't load a team during a pet battle."] = "无法在宠物对战时加载队伍"
	L["You can't load a team in a matched pet battle."] = "无法在已匹配的宠物对战中加载队伍"
	L["Loading..."] = "正在加载..."
	L["Pets are missing from this team!"] = "无法找到这个队伍中的宠物!"
	L["Substitutes were found. Please review the loaded team and click Save if you'd like to keep the chosen pets."] = "发现替补，若要保留已经选择的宠物，请重新查看已经加载的队伍并且按保存"
	L["Don't Warn About Missing Pets"] = "无法找到宠物时不要警告"

-- Process\Roster.lua

-- Process\Filters.lua
	L["Favorites"] = "偏好"
	L["Types"] = "宠物类型"
	L["Strong Vs"] = "重击对方"
	L["Tough Vs"] = "被对方轻击"
	L["Breed"] = "品种"
	L["Similar"] = "相似"
	L["Script"] = "脚本程序"
	L["Level"] = "等级"
	L["Leveling"] = "在升级队列中"
	L["Tradable"] = "可交易"
	L["Battle"] = "对战"
	L["Quantity"] = "稀有程度"
	L["Team"] = "队伍"
	L["Hidden"] = "隐藏"
	L["Zone"] = "地区"
	L["Notes"] = "备注"
	L["Search"] = "搜索"
	L["Sort"] = "排序"

-- Process\PetList.lua
	
-- Process\QueueProcess.lua
	L["All done leveling pets!"] = "宠物已经全部升级完成!"
	L["Rematch's leveling queue is empty"] = "Rematch 的升级队列是空的"
	L["Now leveling:"] = "正在升级:"

-- Process\Sanctuary.lua

-- Menus\Menu.lua
	L["Help"] = "帮助"

-- Menus\TeamMenus.lua
	L["Edit Win Record"] = "编辑战绩"
	L["Edit Team"] = "编辑队伍"
	L["Change Name Or Target"] = "重命名队伍或改变目标"
	L["Set Notes"] = "设定备注"
	L["Leveling Preferences"] = "升级偏好设定"
	L["Move To"] = "移动至"
	L["Move To Top"] = "移至最上方"
	L["Move Up"] = "上移"
	L["Move Down"] = "下移"
	L["Move To End"] = "移至最下方"
	L["Share"] = "共享"
	L["Delete this team?"] = "是否要删除这个队伍?"
	L["Unload Team"] = "取消加载队伍"
	L["Put Leveling Pet Here"] = "将要升级的宠物放在这个栏位"
	L["Add a leveling pet to this team?"] = "是否要在这个队伍中加入等候升级的宠物?"
	L["Import Team"] = "导入队伍"
	L["Import a single team or many teams that was exported from Rematch."] = "导入来自 Rematch 的一个或多个队伍"
	L["Send Team"] = "发送队伍"
	L["Sharing is disabled in options."] = "选项中的共享功能已经禁用"
	L["Send this team to another online user of Rematch."] = "将这个队伍发送给另一位在线上的 Rematch 使用者"
	L["Prompt To Load"] = "提示是否加载队伍"
	L["When your new target has a saved team not already loaded, and the target panel isn't on screen, display a popup asking if you want to load the team.\n\nThis is only for the first interaction with a target. You can always load a target's team from the target panel."] = "如果新的目标已经有一个保存的队伍，但是却未加载，而且屏幕上没有显示目标面板时，弹出队伍面板询问是否要加载队伍。\n\n只有第一次和目标互动时才会提示加载。但你总是可以从目标面板加载目标队伍"
	L["With Rematch Window"] = "同时加载 Rematch 窗口"
	L["Prompt to load with the Rematch window instead of a separate popup dialog."] = "提示并且加载 Rematch 窗口，而不是弹出信息对话框"
	L["Always Prompt"] = "总是提示"
	L["Prompt every time you interact with a target with a saved team not already loaded, instead of only the first time."] = "每次和目标互动，但却没有加载保存的队伍时都提示，而不是只有第一次提示"
	L["When you mouseover a new target that has a saved team not already loaded, immediately load it.\n\nThis is only for the first interaction with a target. You can always load a target's team from the target panel."] = "鼠标指向一个新的目标，但却没有加载保存的队伍时，立即加载。\n\n只有第一次和目标互动时才会提示加载，但你总是可以从目标面板加载目标队伍"
	L["Show After Loading"] = "加载后显示"
	L["After a team auto loads, show the Rematch window."] = "加载队伍后，显示 Rematch 窗口"
	L["Show On Injured"] = "宠物受伤时显示"
	L["When a team auto loads, show the Rematch window if any pets are injured."] = "自动加载队伍时，如果任何一个宠物受伤的话，显示 Rematch 窗口"
	L["On Target Only"] = "选为目标才加载"
	L["Auto load upon targeting only, not mouseover.\n\n\124cffff4040WARNING!\124r This is not recommended! It can be too late to load pets if you target with right click!"] = "只有选取为目标时才自动加载，鼠标指向不加载。\n\n\124cffff4040警告!\124r 不建议使用! 如果你用鼠标右键与目标互动，会来不及加载宠物"
	L["Export Listed Teams"] = "导出列出的队伍"
	L["Export all teams listed below to a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can then paste these teams into their Rematch via Import Teams.\n\nYou can export a single team by right-clicking one and choosing its Share menu."] = "将下面列出的所有队伍导出成字符串，以便复制到其它地方，例如论坛或电子邮件。\n\n其它 Rematch 的使用者可以使用导入队伍的功能，将这些队伍粘贴导入。\n\n要导出单一队伍，在队伍上点鼠标右键，选择共享菜单"
	L["Backup All Teams"] = "备份全部队伍"
	L["Import Teams"] = "导入队伍"
	L["Import From Pet Battle Teams"] = "从 Pet Battle Teams 导入"
	L["Copy your existing teams from Pet Battle Teams to Rematch."] = "将 Pet Battle Teams 中已有的队伍复制到 Rematch"

-- Menus\PetMenus.lua
	L["Unnamed Pets"] = "未命名的宠物"
	L["-- Collected pets that still have their original name.\n\nreturn owned and not customName"] = "-- 收集的宠物中，仍然是原始名字的宠物。\n\nreturn owned and not customName"
	L["Partially Leveled"] = "未完成升级的宠物"
	L["-- Pets that have earned some xp in battle.\n\nreturn xp and xp>0"] = "-- 在对战中获得过经验，但是没有完成升级的宠物。\n\nreturn xp and xp>0"
	L["Unique Abilities"] = "独特技能"
	L["-- Pets with abilities not shared by other pets.\n\nif not count then\n  -- create count of each ability per species\n  count = {}\n  for speciesID in AllSpeciesIDs() do\n    for abilityID in AllAbilities(speciesID) do\n      if not count[abilityID] then\n        count[abilityID] = 0\n      end\n      count[abilityID] = count[abilityID] + 1\n    end\n  end\nend\n\nfor _,abilityID in ipairs(abilityList) do\n  if count[abilityID]==1 then\n    return true\n  end\nend"] = "-- 拥有其它宠物所没有的技能的宠物。\n\nif not count then\n  -- create count of each ability per species\n  count = {}\n  for speciesID in AllSpeciesIDs() do\n    for abilityID in AllAbilities(speciesID) do\n      if not count[abilityID] then\n        count[abilityID] = 0\n      end\n      count[abilityID] = count[abilityID] + 1\n    end\n  end\nend\n\nfor _,abilityID in ipairs(abilityList) do\n  if count[abilityID]==1 then\n    return true\n  end\nend"
	L["Pets Without Rares"] = "非精良属性"
	L["-- Collected battle pets that have no rare version.\n\nif not rares then\n  rares = {}\n  for petID in AllPetIDs() do\n    if select(5,C_PetJournal.GetPetStats(petID))==4 then\n      rares[C_PetJournal.GetPetInfoByPetID(petID)]=true\n    end\n  end\nend\n\nif canBattle and owned and not rares[speciesID] then\n  return true\nend"] = "-- 收集的宠物中，不是精良属性的宠物。\n\nif not rares then\n  rares = {}\n  for petID in AllPetIDs() do\n    if select(5,C_PetJournal.GetPetStats(petID))==4 then\n      rares[C_PetJournal.GetPetInfoByPetID(petID)]=true\n    end\n  end\nend\n\nif canBattle and owned and not rares[speciesID] then\n  return true\nend"
	L["Hybrid Counters"] = "混合技能"
	L["-- Pets with three or more attack types different than their pet type.\n\nlocal count = 0\nfor _,abilityID in ipairs(abilityList) do\n  local abilityType,noHints = select(7, C_PetBattles.GetAbilityInfoByID(abilityID) )\n  if not noHints and abilityType~=petType then\n    count = count + 1\n  end\nend\n\nreturn count>=3\n"] = "-- 拥有三个或以上非自身宠物类型的攻击型技能的宠物。\n\nlocal count = 0\nfor _,abilityID in ipairs(abilityList) do\n  local abilityType,noHints = select(7, C_PetBattles.GetAbilityInfoByID(abilityID) )\n  if not noHints and abilityType~=petType then\n    count = count + 1\n  end\nend\n\nreturn count>=3\n"
	L["Find Similar"] = "寻找相似宠物"
	L["Enter a new name"] = "输入新的名字"
	L["List %d Teams"] = "列出 %d 组队伍"
	L["Hide Pet"] = "隐藏宠物"
	L["Unhide Pet"] = "显示宠物"
	L["Slotted pets cannot be released."] = "位于队伍栏位中的宠物不能被释放"
	L["Release this pet?"] = "是否要释放这个宠物?"
	L["Once released, this pet is gone forever!"] = "一旦释放，宠物将会永远消失!"
	L["Slotted pets cannot be caged."] = "位于队伍栏位中的宠物不能被放入笼中"
	L["Injured pets cannot be caged."] = "受伤的宠物不能被放入笼中"
	L["Cage this pet?"] = "把这个宠物放入笼中?"
	L["Start Leveling"] = "开始升级"
	L["Add To Leveling Queue"] = "加入升级队列"
	L["Stop Leveling"] = "停止升级"
	L["Only Favorites"] = "只有偏好"
	L["Favorite Filters"] = "偏好筛选方式"
	L["Pet Filter"] = "宠物筛选方式"
	L["Reset All"] = "全部重置"
	L["Checkbox Groups"] = "选项框群组"
	L["In filter menus, checkbox groups assume if nothing is checked you want to view all choices.\n\nYou can also:\n\n%s[Shift]+Click\124r to check all except the box clicked.\n\n%s[Alt]+Click\124r to uncheck all except the box clicked."] = "在筛选方式菜单中，如果没有勾选任何一项，表示想要查看全部。\n\n还可以: \n\n%s[Shift]+左键点击\124r 来勾选除了点到的选项框以外的所有项目。\n\n%s[Alt]+左键点击\124r 来取消勾选除了点到的选项框以外的所有项目"
	L["Low Level (1-7)"] = "低级 (1-7)"
	L["Mid Level (8-14)"] = "中级 (8-14)"
	L["High Level (15-24)"] = "高级 (15-24)"
	L["Max Level (25)"] = "最高级 (25)"
	L["Without Any 25s"] = "除了25级"
	L["Moveset Not At 25"] = "未满25级"
	L["You can filter to a specific level or range of levels in the search box. For example, search for:\n\n\%slevel=1\124r\nor\n\%slevel=21-23\124r"] = "可以在搜索框中指定等级或等级范围来筛选，例如搜索:\n\n\%slevel=1，表示等级为1\124r\n或\n\%slevel=21-23，表示等级在21-23之间\124r"
	L["All breed data is pulled from your installed %s%s\124r addon.\n\nThe breed \"New\" categorizes pets with no breed data. Keep your breed addon up to date to see if they have new data."] = "品种数据皆取自于你所安装的插件 %s%s\124r，\n\n\"全新\"品种类别中的宠物没有品种数据。请确保将品种插件更新到最新版本，以便取得新的数据"
	L["Not Leveling"] = "不在升级队列中"
	L["Not Tradable"] = "无法交易"
	L["Can Battle"] = "可以对战"
	L["Can't Battle"] = "无法对战"
	L["One Copy"] = "拥有一只"
	L["Two+ Copies"] = "拥有两只以上"
	L["Three+ Copies"] = "拥有三只以上"
	L["In A Team"] = "同一队伍"
	L["Not In A Team"] = "不在一同队伍"
	L["Current Zone"] = "目前地区"
	L["Hidden Pets"] = "隐藏的宠物"
	L["Has Notes"] = "有备注的"
	L["Reverse Sort"] = "反向排序"
	L["Favorites First"] = "偏好优先"
	L["Sort By"] = "排序方式"
	L["You can filter to a specific range of stats too. For example, search for:\n\n\%shealth>500\124r\nor\n\%sspeed=200-300\124r\n\nThe sort order is not ordinarily reset when filters are reset. The option %sReset Sort With Filters\124r in the Options tab will reset the sort when you reset the filters."] = "也可以依据指定属性的范围来筛选，例如搜索:\n\n\%shealth>500，表示血量大于500\124r\n或\n\%sspeed=200-300，表示速度在200-300之间\124r\n\n重置筛选方式时，排序方式通常不会被重置。选项标签页中的 %s同时重置筛选和排序方式\124r 选项会在重置筛选方式的时候一并重置排序方式"
	L["Find Pets With This Ability"] = "搜索拥有这项技能的宠物"
	L["Hide this pet?"] = "是否要隐藏这个宠物?"
	L["Don't Ask When Hiding Pets"] = "隐藏宠物时不要询问"
	L["Are you sure you want to hide all versions of %s%s\124r?\n\nHidden pets will not show up in the pet list or searches. You can view or unhide these pets in the 'Other' filter."] = "是否要隐藏所有品种的 %s%s\124r?\n\n隐藏的宠物不会在宠物列表和搜索结果中出现。你可以在 '其它' 筛选方式中查看隐藏的宠物或取消隐藏"
	L["Save Filter"] = "保存筛选方式"
	L["A filter must be active before it can be saved."] = "保存一个筛选方式前必须先启动它"
	L["Save this as a favorite filter?"] = "是否要保存为偏好的筛选方式?"
	L["Filters: %s%s\124r\n\nChoose a name to use in the Favorite Filters menu:"] = "筛选方式: %s%s\124r\n\n在偏好的筛选方式菜单中选择要使用的名称:"
	L["Note: Search text and Sort order are not included in the filter."] = "请注意: 筛选方式中不包含搜索文字和排序顺序"
	L["Delete Filter"] = "删除筛选方式"
	L["Are you sure you want to delete the filter named %s%s\124r?"] = "是否确定要删除名为 %s%s\124r 的筛选方式?"
	L["New Script"] = "新增脚本程序"
	L["Create a new pet filter."] = "创建新的宠物筛选方式"
	L["Delete Script"] = "删除脚本程序"
	L["Are you sure you want to delete the script named %s%s\124r?"] = "是否确定要删除名为 %s%s\124r 的脚本程序?"

	-- Menus\Npcs.lua
	L["Eastern Kingdom"] = "东部王国"
	L["Kalimdor"] = "卡利姆多"
	L["Outland"] = "外域"
	L["Northrend"] = "诺森德"
	L["Cataclysm"] = "大地的裂变"
	L["Pandaria"] = "潘达利亚"
	L["Beasts of Fable"] = "寓言之兽"
	L["Celestial Tournament"] = "天神比武大会"
	L["Draenor"] = "德拉诺"
	L["Garrison"] = "要塞"
	L["Menagerie"] = "宠物小屋"
	L["Tanaan Jungle"] = "塔纳安丛林"
	L["No Target"] = "没有对手"
	L["Noteworthy Targets"] = "值得一战的对手"
	L["These are noteworthy targets such as tamers and legendary pets.\n\nChoose one to view the pets you would battle.\n\nTargets with a \124TInterface\\RaidFrame\\ReadyCheck-Ready:14\124t already have a team saved."] = "驯宠师和传说宠物都是值得一战的对手，\n\n选择其中一个来查看你想要对战的宠物。\n\n目标前显示 \124TInterface\\RaidFrame\\ReadyCheck-Ready:14\124t 表示该目标已有保存的队伍"

-- Dialogs\Dialog.lua
	L["Tab:"] = "标签页:"

-- Cards\PetCard.lua
	L["Damage\nTaken"] = "受到的\n伤害"
	L["from"] = "来自"
	L["abilities"] = "技能"
	L["Unpin Pet Card"] = "取消固定显示宠物卡"
	L["While pinned, the pet card will display where you last moved it.\n\nClick this to unpin the pet card and snap it back to the pets."] = "固定显示时，宠物卡会一直显示在最后移动的位置"
	L["Pet Card"] = "宠物卡"
	L["Hold [Alt] to view more about this pet."] = "按住 [Alt] 查看关于这个宠物的详细信息"
	L["XP: %d/%d (%d%%)"] = "经验值: %d/%d (%d%%)"
	L["Possible Breeds"] = "可能的品种"
	L["Slotted"] = "已在队伍中"
	L["This pet is loaded in one of the three battle pet slots."] = "这个宠物已在战斗栏位中"
	L["Favorite"] = "偏好"
	L["This pet is marked as a Favorite from its right-click menu."] = "这个宠物已被设为偏好"
	L["This pet is in Rematch's leveling queue."] = "这个宠物在 Rematch 的升级队列中"
	L["Determines how stats are distributed.  All breed data is pulled from your installed %s%s\124r addon."] = "决定属性分布， 所有品种数据皆取自于你所安装的插件 %s%s\124r"
	L["Species ID"] = "物种ID"
	L["All versions of this pet share this unique \"species\" number."] = "此宠物的所有品种共享这个唯一的\"物种\"编号."
	L["%d Teams"] = "%d 组队伍"
	L["Teams"] = "队伍"
	L["%s Click to search for all teams that include this pet."] = "点击搜索所有包含这只宠物的队伍"
	L["%s Click to search for all versions of this pet."] = "点击搜索这只宠物的所有品种"
	L["When this team loads, your current leveling pet will go in this spot."] = "加载这个队伍时，当前正在升级的宠物会被放在这个栏位"
	L["This is an opponent pet."] = "这是敌对的宠物"
	L["All breed data pulled from %s%s\124r."] = "品种数据取自 %s%s\124r"
	L["Stats At Level 25 \124cff0070ddRare"] = "25级\124cff0070dd精良\124r品质属性"
	L["No known breeds :("] = "未知的品种 :("

-- Cards\AbilityCard.lua
	L["Vs"] = nil
	
	-- Cards\Notes.lua
	L["Pet Notes"] = "宠物备注"
	L["Delete Notes"] = "删除备注"
	L["Are you sure you want to delete the notes for %s\124r?"] = "是否要删除 %s\124r 的备注?"

-- Cards\WinRecord.lua
	L["Win Record"] = "战绩"
	L["Hold [Alt] to view totals for all teams."] = "按[Alt]键查看所有队伍的战绩"
	L["Wins:"] = "胜"
	L["Losses:"] = "负"
	L["Draws:"] = "平"
	L["Totals Across All Teams"] = "总计"
	L["%s%s\124r Battles"] = "%s%s\124r 战斗"
	L["+1 Win"] = "+1 胜"
	L["+1 Loss"] = "+1 负"
	L["+1 Draw"] = "+1 平"
	L["Reset Win Record"] = "重置战绩"
	L["Are you sure you want to remove all wins, losses and draws from the team \"%s\"?"] = "要删除队伍\"%s\"的全部战绩吗?"
	L["Reset All Win Records"] = "重置全部战绩"
	L["Are you sure?"] = "确定?"
	L["This will remove win record data for all teams and cannot be undone!"] = "这将会重置所有队伍的战绩，并且无法恢复！"
	L["Convert Team Names To Win Records"] = "转换队伍名字为战绩格式"
	L["Convert"] = "转换"
	L["This will look for teams with names that may include win-loss-draw stats and pull those into an actual win record before removing the numbers from the team name.\n\nDo you want to convert these teams?\n\nThe currently loaded team will be unloaded to prevent major complications.\n\n\124cffff1111Please backup your teams before attempting this!"] = "这将会查询所有队伍名字中包含 胜-负-平 格式统计记录的队伍(例如123-45-6, 表示123胜，45负，6平)，然后把这些数字转换成真实的战绩记录，最后删除从队伍名字中删除这些数字。\n\n你想要转换这些队伍吗?\n\n当前加载的队伍会被取消加载，以防止各种奇葩的错误。\n\n\124cffff1111这么做之前请备份你的队伍!"
	L["Done!"] = "完成！"
	L["%s%d teams and %d battles were converted."] = "%s%d 队伍和 %d 战绩 已经被转换了"

-- Panels\PetPanel.lua
	L["Strong vs"] = "重击对方"
	L["Tough vs"] = "被对方轻击"
	L["Pets: %s%d"] = "宠物: %s%d"
	L["Filters: %s%s"] = "筛选方式: %s%s"

-- Panels\LoadoutPanel.lua
	L["Target has a saved team"] = "该目标已有保存的队伍"
	L["Load"] = "加载"
	L["Load the team saved for this target."] = "加载这个目标的对应队伍"
	L["This target has no saved team"] = "该目标没有保存的队伍"
	L["Save the currently loaded pets to this target."] = "保存目前已经加载的宠物，供这个目标使用"

-- Panels\TeamPanel.lua

-- Panels\QueuePanel.lua
	L["Ascending Level"] = "等级由低至高"
	L["Descending Level"] = "等级由高至低"
	L["Median Level"] = "等级中间值"
	L["Type"] = "宠物类型"
	L["Queue"] = "升级队列"
	L["Sort by:"] = "排序方式:"
	L["Sort all pets in the queue from level 1 to level 24."] = "依据等级1至24来排序升级队列中的所有宠物"
	L["Sort all pets in the queue for levels closest to 10.5."] = "依据等级接近10.5来排序升级队列中的所有宠物"
	L["Sort all pets in the queue from level 24 to level 1."] = "依据等级24至1来排序升级队列中的所有宠物"
	L["Sort all pets in the queue by their types."] = "依据宠物类型来排序升级队列中的所有宠物"
	L["Active Sort"] = "主动排序"
	L["The queue will stay sorted in the order chosen. The order of pets may automatically change as they gain xp or get added/removed from the queue.\n\nYou cannot manually change the order of pets while the queue is actively sorted."] = "升级队列会依据选择的先后来排序，当宠物获得经验值，或从升级队列新增/移除时，排序顺序可能会自动改变。\n\n升级队列主动排序时，将无法手动更改宠物的顺序"
	L["Pause Preferences"] = "暂停偏好"
	L["Suspend all preferred loading of pets from the queue, except for pets that can't load."] = "暂停所有从升级队列加载宠物的特别偏好，除了那些无法加载的宠物"
	L["Fill Queue"] = "加入升级队列"
	L["Fill the leveling queue with one of each version of a pet that can level from the filtered pet list, and for which you don't have a level 25 or one in the queue already."] = "将宠物筛选列表中可以升级的，未满25级的宠物，每个品种一个，加入升级队列"
	L["Fill Queue More"] = "加入更多到升级队列"
	L["Fill the leveling queue with one of each version of a pet that can level from the filtered pet list, regardless whether you have any at level 25 or one in the queue already."] = "将宠物筛选列表中可以升级的，每个品种一个，加入升级队列，无论你是否已经有一个25级的该宠物或者它已经位于升级队列"
	L["Empty Queue"] = "清空升级队列"
	L["Remove all leveling pets from the queue."] = "移除升级队列中所有等待升级的宠物"
	L["Are you sure you want to remove all pets from the leveling queue?"] = "是否要移除升级队列中的所有宠物?"
	L["No Active Sort"] = "禁用主动排序"
	L["Turn off Active Sort. Queued pets can then be rearranged and will not automatically reorder themselves.\n\nTo turn Active Sort back on, check %sActive Sort\124r in the Queue menu."] = "关闭主动排序，手动排序等候的宠物，而且不会重新自动排序。\n\n要重新打开主动排序，请点击升级队列菜单中的 %s主动排序\124r"
	L["Turn Off Active Sort?"] = "是否要关闭主动排序?"
	L["Leveling Pets: %s%s"] = "升级中的宠物: %s%s"
	L["Active Sort:"] = "主动排序:"
	L["Add these pets to the queue?"] = "是否要将这些宠物加入到升级队列?"
	L["This will add %s%d\124r pets to the leveling queue.\n\nYou can be more selective by filtering pets.\n\nFor instance, if you filter pets to High Level (15-24) and Rare, Fill Queue will only add rare pets between level 15 and 24."] = "将 %s%d\124r 宠物加入到升级队列，\n\n使用筛选方式来选择要加入的宠物。\n\n举例来说，如果筛选方式是高等级 (15-24) 和精良，那么只有等级15到24的精良宠物才会加入升级队列"
	L["This will add %s%d\124r pets to the leveling queue."] = "将 %s%d\124r 宠物加入到升级队列"

-- Panels\MiniQueue.lua

-- Panels\MiniPanel.lua
	L["This target has a saved team"] = "目标有已保存的队伍"

-- Panels\OptionPanel.lua
	L["All Options"] = "所有选项"
	L["Targeting Options"] = "目标选项"
	L["Auto load upon targeting only, not mouseover.\n\n\124cffff4040WARNING!\124r This is not recommended! It can be too late to load pets if you target with right-click!"] = "只有选取为目标时才自动加载，鼠标指向不加载。\n\n\124cffff4040警告!\124r 不建议使用! 如果用鼠标右键选取目标的话，会来不及加载宠物"
	L["Always Show When Targeting"] = "选取目标时总是显示"
	L["Regardless whether a target's team is already loaded, show the Rematch window when you target something with a saved team."] = "不论是否已经加载目标的队伍，选取的目标有已保存的队伍时，显示 Rematch 窗口"
	L["Preferred Window Mode"] = "偏好的窗口模式"
	L["Minimized Standalone"] = "小型独立窗口"
	L["When automatically showing the Rematch window, show the minimized standalone window."] = "自动显示 Rematch 窗口时，显示小型独立窗口"
	L["Maximized Standalone"] = "大型独立窗口"
	L["When automatically showing the Rematch window, show the maximized standalone window."] = "自动显示 Rematch 窗口时，显示大型独立窗口"
	L["Pet Journal"] = "系统宠物界面"
	L["When automatically showing the Rematch window, show the pet journal."] = "自动显示 Rematch 窗口时，显示系统宠物界面"
	L["Standalone Window Options"] = "独立窗口选项"
	L["Use Custom Scale"] = "使用自定义缩放大小"
	L["Change the relative size of the standalone window to anywhere between 50% and 200% of its standard size."] = "更改独立窗口的相对大小，介于标准大小的50%与200%之间"
	L["Single Panel Mode"] = "单一面板模式"
	L["Collapse the maximized standalone window to one panel instead of two side by side.\n\nUsers of earlier versions of Rematch may find this mode more familiar."] = "整合大型独立窗口，使用单一的，而不是两个相邻的面板。\n\n Rematch 早期版本的使用者会对这个模式比较熟悉"
	L["Combine Pets And Queue"] = "合并宠物和升级队列"
	L["In single panel mode, combine the Pets and Queue tabs together. A narrow queue will display to the right of the pet list instead of in a separate tab."] = "在单一面板模式中，合并宠物和升级队列标签页。较窄的升级队列会显示在宠物列表的右方，而不是另一个分开的标签页"
	L["Keep Window On Screen"] = "总是显示独立窗口"
	L["Don't hide the standalone window when the ESCape key is pressed or most other times it would hide, such as going to the game menu."] = "点击 Esc 键或其它可能隐藏窗口的时候，都不要隐藏独立窗口，例如开启游戏菜单"
	L["Even For Pet Battles"] = "宠物对战时也要显示"
	L["Keep the standalone window on the screen even when you enter pet battles."] = "宠物对战时也保持显示独立窗口"
	L["Even Across Sessions"] = "下次登录时也要显示"
	L["If the standalone window was on screen when logging out, automatically summon it on next login."] = "如果登出时有显示独立窗口，下次登录时也要自动显示"
	L["Don't Minimize With ESC Key"] = "按 Esc 键时不要最小化"
	L["Don't minimize the standalone window when the ESCape key is pressed."] = "点击Esc键时不要最小化独立窗口"
	L["Lower Window Behind UI"] = "显示在UI下方"
	L["Push the standalone window back behind other parts of the UI so other parts of the UI can appear ontop."] = "将窗口显示在其它UI界面的下层，让其它UI界面显示在顶层"
	L["Move Panel Tabs To Right"] = "面板标签页移动至右侧"
	L["Align the Pets, Teams, Queue and Options tabs to the right side of the standalone window."] = "将宠物、队伍、升级队列和选项标签页对齐到独立窗口的右侧"
	L["Minimal Minimized Window"] = "最小化小型窗口"
	L["Remove the titlebar and tabs when the standalone window is minimized."] = "独立窗口最小化时，不显示标题列和标签页"
	L["Appearance Options"] = "外观选项"
	L["Compact List Format"] = "小型列表格式"
	L["Use an alternate style of lists for Pets, Teams and Queue to display more on the screen at once.\n\n\124cffff4040This option requires a Reload."] = "使用另一种列表样式来显示宠物、队伍和升级队列，一次可以显示更多项目"
	L["Use Smaller Text Too"] = "同时使用较小的文字"
	L["Also use smaller text in the Compact List Format so more text displays on each button."] = "在小型列表格式中同时也使用较小的文字，让每个按钮可以显示更多文字"
	L["Color Pet Names By Rarity"] = "宠物名字依据稀有程度着色"
	L["Make the names of pets you own the same color as its rarity. Blue for rare, green for uncommon, etc."] = "让宠物名字颜色和它的稀有程度相同，蓝色表示精良、绿色表示优秀...等等"
	L["Hide Rarity Borders"] = "隐藏稀有程度边框"
	L["Don't color the icon border for pets you own in the same color as its rarity."] = "宠物图标外框，不使用和稀有程度相同的颜色"
	L["Hide Level At Max Level"] = "最高等级时隐藏等级"
	L["If a pet is level 25, don't show its level on the pet icon."] = "如果宠物的等级是25，宠物图标不显示等级"
	L["Show Ability Numbers"] = "显示技能数字"
	L["In the ability flyout, show the numbers 1 and 2 to help with the common notation such as \"Pet Name 122\" to know which abilities to use."] = "在技能选择下拉框中，显示数字 1 和 2 以方便识别使用的是哪个技能。例如 \"宠物名字 122\""
	L["Toolbar Options"] = "工具条选项"
	L["Move Toolbar To Bottom"] = "工具条移动至下方"
	L["Move the toolbar buttons (Revive Battle Pets, Battle Pet Bandages, Safari Hat, etc) to the bottom of the standalone window.\n\nAlso convert the red panel buttons (Save, Save As, Find Battle) to toolbar buttons."] = "将工具条按钮 (复活战斗宠物、战斗宠物绷带、狩猎帽...等等) 移动到独立窗口的下方，\n\n同时将红色面板按钮 (保存、另存为、寻找对战) 显示为工具条按钮"
	L["Reverse Toolbar Buttons"] = "反向排序工具条按钮"
	L["Reverse the order of the toolbar buttons (Revive Battle Pets, Battle Pet Bandages, Safari Hat, etc)."] = "反向排序工具条按钮的顺序 (复活战斗宠物、战斗宠物绷带、狩猎帽...等等)"
	L["Hide On Toolbar Right Click"] = "在工具条上点鼠标右键时隐藏"
	L["When a toolbar button is used with a right click, dismiss the Rematch window after performing its action."] = "使用鼠标右键点工具条按钮时，执行按钮动作后关闭 Rematch 窗口"
	L["Safari Hat Reminder"] = "提醒使用狩猎帽"
	L["Draw attention to the safari hat button while a pet below max level is loaded.\n\nAlso show the Rematch window when a low level pet loads and the safari hat is not equipped."] = "加载不满级的宠物时，高亮狩猎帽按钮。\n\n同时在没有装备狩猎帽并且加载低级宠物时，显示 Rematch 窗口"
	L["Pet Card & Notes Options"] = "宠物卡 & 备注选项"
	L["Allow Pet Cards To Be Pinned"] = "允许固定宠物卡"
	L["When dragging a pet card to another part of the screen, pin the card so all future pet cards display in the same spot, until the pet card is moved again or the unpin button is clicked."] = "将宠物卡移动到屏幕上的另一个位置后，固定宠物卡，以便让所有想要看的宠物卡都能够同时显示。直到再次移动宠物卡，或是点击取消固定的按钮"
	L["Click For Pet Cards & Notes"] = "点击显示宠物卡 & 备注"
	L["Instead of automatically showing pet cards and notes when you mouseover them, require clicking the pet or notes button to display them."] = "鼠标点击宠物和备注按钮时显示宠物卡和备注，而不是鼠标指向"
	L["Faster Pet Cards & Notes"] = "快速显示宠物卡 & 备注"
	L["Instead of a small delay before showing pet cards and notes, immediately show them as you mouseover pets and notes buttons."] = "鼠标指向宠物和备注按钮时立即显示宠物卡和备注，不要有短暂的延迟"
	L["Use Pet Cards In Battle"] = "在对战时使用宠物卡"
	L["Use the pet card on the unit frames during a pet battle instead of the default tooltip."] = "在宠物对战时，在单位框体中使用宠物卡，而不是默认的鼠标提示"
	L["Use Pet Cards For Links"] = "使用宠物卡作为链接"
	L["Use the pet card when viewing a link of a pet someone else sent you instead of the default link."] = "当别人给你发送一个宠物链接时，使用宠物卡，而不是默认的链接"
	L["Show Team Cards"] = "显示队伍卡"
	L["Show a card with team details when you mouseover a team.\n\n%sIMPORTANT:\124r While this option is enabled, clicking a team will lock the team card instead of loading it. %sDouble-Click\124r to load a team with this option enabled, just as you would Double-Click a pet to summon it."] = "当鼠标滑过队伍时显示队伍详情卡，\n\n%s重要:\124r 如果开启该选项，点击一个队伍将会锁定该队伍卡，而不是加载该队伍"
	L["Keep Notes On Screen"] = "一直显示备注"
	L["Don't hide notes when the ESCape key is pressed or other times it would hide, such as changing tabs or closing Rematch."] = "点击Esc键或其它会隐藏备注的情况下，不要隐藏备注。例如切换标签页或关闭 Rematch"
	L["Show Notes Upon Targeting"] = "显示目标的备注"
	L["When your target has a saved team with notes, automatically display and lock the notes."] = "选择的目标有已经保存的队伍和备注时，自动显示并且锁定备注"
	L["Show Notes In Battle"] = "对战中显示备注"
	L["If the loaded team has notes, display and lock the notes when you enter a pet battle."] = "如果加载的队伍有备注，进入宠物对战时显示并且锁定备注"
	L["Only Once Per Team"] = "每个队伍只显示一次"
	L["Only display notes automatically the first time entering battle, until another team is loaded."] = "只有第一次进入对战时自动显示备注，直到加载下一个队伍"
	L["Alternate Lore Font"] = "较大的故事背景文字"
	L["Use a more normal-looking font for lore text on the back of the pet card."] = "宠物卡背面的宠物故事背景文字使用较大的字体"
	L["Show Species ID On Pet Cards"] = "在宠物卡上显示物种ID"
	L["Display the numerical species ID of a pet as a stat on their pet card."] = "在宠物卡上显示物种ID"
	L["Team Options"] = "队伍选项"
	L["Hide Targets Below Teams"] = "隐藏队伍的其它目标"
	L["Hide the target name that appears beneath a team that is not named the same as its target."] = "隐藏队伍当前目标以外的目标名称"
	L["Always Show Team Tabs"] = "总是显示队伍标签页"
	L["Show team tabs along the right side of the window even if you're not on the team panel."] = "即使不是队伍面板，窗口右侧仍然显示队伍标签页"
	L["Move Team Tabs To Left"] = "队伍标签页移动至左侧"
	L["Move the team tabs along the right side of the standalone window to the left side."] = "将独立窗口右侧的队伍标签页移动至左侧"
	L["Auto Track Win Record"] = "自动记录战绩"
	L["At the end of each battle, automatically record whether the loaded team won or lost.\n\nForfeits always count as a loss.\n\nYou can still manually update a team's win record at any time."] = "对战结束时，自动记录目前队伍的胜负。\n\n逃跑会被记为负。\n你任何时候都可以手动更新战绩"
	L["For PVP Battles Only"] = "仅限 PVP 宠物对战"
	L["Automatically track whether the loaded team won or lost only in a PVP battle and never for a PVE battle."] = "只自动记录PVP宠物对战的记录，而不记录PVE对战"
	L["Display Total Wins Instead"] = "显示总胜场数"
	L["Instead of displaying the win percentage of a team on the win record button, display the total number of wins.\n\nTeam tabs that are sorted by win record will sort by total wins also."] = "在战绩按钮上显示总胜场数，而不是胜率。\n\n同时队伍标签页会按胜场数排序"
	L["Hide Win Record Buttons"] = "隐藏战绩按钮"
	L["Hide the win record button displayed to the right of each team.\n\nYou can still manually edit a team's win record from its right-click menu and automatic tracking will continue if enabled."] = "隐藏每个队伍右侧的战绩按钮\n\n你也可以在队伍的右键菜单中手动编辑战绩，如果自动记录启用，它也会继续记录"
	L["Leveling Queue Options"] = "升级队列选项"
	L["Prefer Living Pets"] = "优先活的宠物"
	L["When loading pets from the queue, skip dead pets and load living ones first."] = "从升级队列加载宠物时，跳过已死亡的宠物，优先加载活的宠物"
	L["And At Full Health"] = "并且满血的宠物"
	L["Also prefer uninjured pets when loading pets from the queue."] = "从升级队列加载宠物时，同时优先未受伤的宠物"
	L["Double Click To Send To Top"] = "双击排到最上方"
	L["When a pet in the queue panel is double clicked, send it to the top of the queue instead of summoning it."] = "在升级队列的面板双击宠物时，将它排到升级队列的最上方，而不是召唤"
	L["Hide Leveling Pet Toast"] = "加载待升级宠物到队伍时不显示通知"
	L["Don't display the popup 'toast' when a new pet is automatically loaded from the leveling queue."] = "自动从升级队列加载新宠物时，不显示提示框"
	L["Automatically Level New Pets"] = "自动升级新宠物"
	L["When you capture or learn a pet, automatically add it to the leveling queue."] = "捕获或学会宠物时，自动加入到升级队列"
	L["Only Pets Without A 25"] = "仅未满25级的宠物"
	L["Only automatically level pets which don't have a version already at 25 or in the queue."] = "相同宠物中没有任何一个是25级或在升级队列中时，才自动升级宠物"
	L["Only Rare Pets"] = "仅精良宠物"
	L["Only automatically level rare quality pets."] = "仅自动升级精良属性的宠物"
	L["Pet Filter Options"] = "宠物筛选方式选项"
	L["Reset Filters On Login"] = "登录时重置筛选方式"
	L["When logging in, start with all pets listed and no filters active."] = "登录时，将所有宠物列表重置为未使用任何筛选方式"
	L["Reset Sort With Filters"] = "重置筛选时也重新排序"
	L["When clearing filters, also reset the sort back to the default: Sort by Name, Favorites First."] = "清除筛选方式时也一并将排序重置为默认值: 依照名字、偏好优先排序"
	L["Don't Reset Search With Filters"] = "重置筛选时不清除搜索框"
	L["When manually clearing filters, don't clear the search box too.\n\nSome actions, such as logging in or Find Similar, will always clear search regardless of this setting."] = "手动清除筛选方式时，不要清除搜索框。\n\n某些动作，例如登录或搜索相似宠物，总是会清除搜索框，并无视这个设定"
	L["Sort By Chosen Name"] = "按自定义的名字排序"
	L["When pets are sorted by name, sort them by the name given with the Rename option instead of their original name."] = "按名字排序时，按重命名后的名字排序，而不是原始名字"
	L["Miscellaneous Options"] = "其它选项"
	L["Show After Pet Battle"] = "宠物对战结束后显示"
	L["Show the Rematch window after leaving a pet battle."] = "对战结束后显示 Rematch 窗口"
	L["Disable Sharing"] = "禁用共享"
	L["Disable the Send button and also block any incoming pets sent by others. Import and Export still work."] = "禁用发送按钮，也会阻止其它玩家发送过来的任何宠物。导出和导入仍能正常使用"
	L["Don't display a popup when a team loads and a pet within the team can't be found."] = "加载的队伍中无法找到的宠物时，不显示弹出信息"
	L["Don't ask for confirmation when hiding a pet.\n\nYou can view hidden pets in the 'Other' pet filter."] = "隐藏宠物时不要询问，\n\n在 '其它' 宠物筛选方式中可以看到隐藏的宠物"
	L["Use Minimap Button"] = "使用小地图按钮"
	L["Place a button on the minimap to toggle Rematch and load favorite teams."] = "在小地图旁放置一个按钮，可供切换显示 Rematch 和加载偏好的队伍"
	L["Keep Companion"] = "保持作伴的宠物"
	L["After a team is loaded, summon back the companion that was at your side before the load; or dismiss the pet if you had none summoned."] = "队伍加载后，将原本在身边作伴的宠物重新召唤回来，若身边原本没有宠物，就解散宠物"
	L["Hide Tooltips"] = "隐藏鼠标提示"
	L["Hide the more common tooltips in Rematch."] = "隐藏 Rematch 的常规鼠标提示"
	L["Hide Extra Help"] = "隐藏附加帮助"
	L["Hide the informational \"Help\" items found in many menus and on the pet card."] = "隐藏大部分菜单和宠物卡中的\"帮助\"条目"
	L["Use Default Pet Journal"] = "使用系统默认的宠物界面"
	L["Turn off Rematch integration with the default pet journal.\n\nYou can still use Rematch in its standalone window, accessed via key binding, /rematch command or from the Minimap button if enabled in options."] = "关闭 Rematch ，使用系统默认的宠物界面。\n\n仍然可以使用绑定的按键、指令 /rematch 和小地图按钮 (选项中有启用时) 来使用独立窗口的 Rematch"
	L["Rematch version %s"] = "Rematch 版本 %s"
	L["The%s icon indicates new options."] = "%s 图标代表新的选项"
	L["Anchor"] = "位置"
	L["Bottom Right"] = "右下"
	L["Top Right"] = "右上"
	L["Bottom Left"] = "左下"
	L["Top Left"] = "左上"
	L["Anchor: %s"] = "位置: %s"
	L["When the standlone window is minimized, send it to the %s corner."] = "独立窗口最小化时，缩小至%s角"
	L["Current Scale: %d%%"] = "目前缩放大小: %d%%"
	L["Click here to choose a different scale for the standalone window."] = "点这里为独立窗口选择不同的缩放大小"
	L["\n\n%sThis will close the journal and open the standalone window."] = "\n\n%s会关闭日志并开启独立窗口"
	L["Reload the UI now?"] = "是否要立即重新加载界面?"
	L["You've chosen to change the setting for Compact List Format.\n\nThis change doesn't take effect until a reload or logout."] = "你已经选择更改小型列表格式的设置，\n\n必须重新加载界面或登出，这项变更才会生效"
	L["Custom Scale"] = "自定义缩放大小"
	L["Keep this scale?"] = "是否要保留这个缩放大小?"
	L["This scale determines the relative size of the standalone window, where 100% is the standard size."] = "将会检测独立窗口的相对大小来缩放，标准大小是100%"
	
-- Widgets\BottomPanel.lua
	L["You can also double-click a pet to summon or dismiss it."] = "也可以双击来召唤或解散宠物"
	L["Disable Rematch"] = "禁用 Rematch"
	L["Uncheck this to restore the default pet journal.\n\nYou can still use Rematch in its standlone window, accessed via key binding, /rematch command or from the Minimap button if enabled in options."] = "取消勾选以恢复系统默认的宠物界面\n\n你仍然可以在独立窗口中使用 Rematch ，可以使用绑定的按键、/rematch 指令或小地图按钮 (如果启用该选项) 来开启独立窗口"

-- Widgets\TeamTabs.lua
	L["Edit Tab"] = "编辑标签页"
	L["Change the name or icon of this tab."] = "更改这个标签页的名称或图标"
	L["Custom Sort"] = "自定义排序"
	L["Remove Custom Sort"] = "移除自定义排序"
	L["Are you sure you want to remove the custom sort order?\n\nThe saved order of teams will be lost and turning this option back on will not restore the old order."] = "是否要移除自定义排序?\n\n已保存的队伍排序将会丢失，并且重设该选项也不能恢复原有的排序"
	L["While checked, you can rearrange the order of teams within this tab from the teams' right-click menu."] = "勾选时，在本选项卡中，你可以在队伍的右键菜单中重新排序"
	L["Sort By Wins"] = "按胜场排序"
	L["This option is disabled while Custom Sort is active."] = "当自定义排序启用时，该选项会被禁用"
	L["Sort teams in this tab by their wins.\n\nFavorited teams will still list at the top."] = "在该标签页中按胜场排序队伍，\n\n偏好的队伍始终会在顶部"
	L["Set leveling preferences for all teams within this tab.\n\nIf a team within this tab also has preferences, the tab's preferences will take priority over the team's preferences."] = "为这个标签页中的所有队伍设定升级偏好设定，\n\n当标签页本身也有偏好设定时，标签页的偏好设定会优先于队伍偏好设定"
	L["Export Tab"] = "导出标签页"
	L["Export all teams in this tab to a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can then paste these teams into their Rematch via Import Teams.\n\nYou can export a single team by right-clicking one and choosing its Share menu."] = "将标签页中的所有队伍导出成纯文字，以便复制到其它地方，例如论坛或电子邮件。\n\n已经使用 Rematch 的玩家可以使用导入队伍的功能，将这个队伍粘贴导入。\n\n要导出单一队伍，在队伍上点鼠标右键，选择共享菜单"
	L["Delete Tab"] = "删除标签页"
	L["Delete this tab and move all of its teams to the default tab."] = "删除这个标签页，将里面的所有队伍移动至默认标签页"
	L["Create New Tab"] = "创建新的标签页"
	L["Teams: %d"] = "队伍: %d"
	L["New Tab"] = "新标签页"
	L["Choose a name and icon"] = "选择名称和图标"
	L["Delete this tab?"] = "是否确定要删除这个标签页?"
	L["Deleting this tab will move its teams to the %s tab."] = "删除标签页会将里面的队伍移动至 %s 标签页"

-- Widgets\LoadedTeamPanel.lua
	L["Reload Team"] = "重新加载队伍"
	L["When a team is loaded its name goes here. You can reload the team by clicking here or right-click for team options such as setting notes."] = "队伍加载后会在这里显示队伍名，点击这里可以重新加载队伍，或点鼠标右键显示队伍选项，例如设定备注"
	L["Last Loaded Team"] = "上次加载的队伍"

-- Dialogs\Save.lua
	L["Target For This Team"] = "这个队伍的目标"
	L["A target stored in a team is used to decide which team to load when you return to that target.\n\nYou can save an unlimited number of teams to fight a target, but a target can only be saved in one team."] = "再次和遇到目标时，会使用队伍中所保存的目标来决定要加载哪个队伍。\n\n每个队伍只能保存一个目标，但可以保存无限数量的队伍与同一个目标对战"
	L["Name:"] = "队伍名:"
	L["Target:"] = "目标:"
	L["Save As.."] = "另存为..."
	L["Save this team?"] = "是否要保存这个队伍?"
	L["Save Notes & Preferences Too"] = "同时同时保存备注和偏好设定"
	L["All teams must have a name."] = "必须为队伍指定一个队伍名"
	L["This target already has a team."] = "这个目标已经有队伍"
	L["A team already has this name."] = "已经有队伍使用这个名称"
	L["Overwrite Team"] = "覆盖队伍"
	L["Overwrite this team?"] = "是否确定要覆盖这个队伍?"
	L["The target %s%s\124r already has a team.\n\nA target can only have one team."] = "目标 %s%s\124r 已经有队伍，\n\n一个目标只能有一个队伍"
	L["A team named %s%s\124r already exists.\n\nTeams without a target must have a unique name."] = "%s%s\124r 队伍名已经存在，\n\n如果队伍没有对应的目标，那么它的队伍名必须是唯一的"

-- Dialogs\Preferences.lua
	L["Minimum Health"] = "最低血量"
	L["This is the minimum health preferred for a leveling pet.\n\nThe queue will prefer leveling pets with at least this much health (adjusted by expected damage taken if any chosen)."] = "要升级的小宠的最低血量，\n\n升级队列会优先选择满足这个最低血量设置的宠物 (最低血量值会根据预期受到的伤害进行调整)"
	L["Minimum Level"] = "最低等级"
	L["This is the minimum level preferred for a leveling pet.\n\nLevels can be partial amounts. Level 4.33 is level 4 with 33% xp towards level 5."] = "要升级的小宠的最低等级\n\n等级可以有小数点，等级 4.33 表示4级，还需要33%的经验值升到5级"
	L["Maximum Health"] = "最高血量"
	L["This is the maximum health preferred for a leveling pet."] = "要升级的小宠的最高血量"
	L["Maximum Level"] = "最高等级"
	L["This is the maximum level preferred for a leveling pet.\n\nLevels can be partial amounts. Level 23.45 is level 23 with 45% xp towards level 24."] = "要升级的小宠的最高等级\n\n等级可以有小数点，等级 23.45 表示23级，还需要45%的经验值到24级"
	L["Or any"] = "或任何"
	L["Allow low-health Magic and Mechanical pets to ignore the Minimum Health, since their racials allow them to often survive a hit that would ordinarily kill them."] = "允许低血量的魔法和机械宠物忽略最低血量设置，因为种族技能让它们在受到致命一击后常常还能生存下来"
	L["Expected Damage Taken"] = "预期受到的伤害"
	L["Tab"] = "标签页"
	L["Leveling Preferences"] = "升级设定"
	L["Team Preferences"] = "队伍设定"
	L["Tab Preferences"] = "标签页设定"
	L["  For %s pets: %s%d%s"] = "%s 宠物最低血量: %s%d%s"
	L["%s %sTab Preferences"] = "%s %s标签页设定"
	L["%s%s Preferences Paused"] = "已暂停 %s%s 设定"
	L["%s Resume Preferences"] = "%s 恢复设定"
	L["%s Pause Preferences"] = "%s 暂停设定"
	L["Leveling Preferences For %s:"] = "%s 的升级设定:"
	L["Expected damage taken"] = "预期受到的伤害"
	L["The minimum health of pets can be adjusted by the type of damage they are expected to receive."] = "宠物的最低血量会根据预期受到的伤害类型调整"
	L["Damage expected"] = "预期受到的伤害"
	L["  For %s pets: \124cffffd200%d"] = "%s 宠物最低血量: \124cffffd200%d"

-- Dialogs\Sideline.lua
	L["New Team"] = "新增队伍"

-- Dialogs\Share.lua
	L["%s (NPC#%d)"] = nil
	L["%s (%s NPC#%d)"] = nil
	L["%d: %s"] = nil
	L["%d: %s (%d,%d,%d)"] = nil
	L["Preferred leveling pets: %s."] = "偏好的要升级的小宠: %s."
	L["at least %d health"] = "最少%d血"
	L["at least %d health (or any Magic/Mechanical)"] = "最少%d血（或者任意的魔法/机械宠物）"
	L["at least %d health (%s damage expected)"] = "最少%d血 （%s伤害预计）"
	L["at least %d health (or any Magic/Mechanical, %s damage expected)"] = "最少%d血 (或者任意的魔法/机械宠物， %s伤害预计)"
	L["at most %d health"] = "最多%d血"
	L["at least level %s"] = "最低%s级"
	L["at most level %s"] = "最高%s级"
	L["Export Team"] = "导出队伍"
	L["Press Ctrl+C to copy these teams to the clipboard."] = "按 Ctrl+C 复制这些队伍"
	L["Press Ctrl+C to copy this team to the clipboard."] = "按 Ctrl+C 复制这个队伍"
	L["Include Preferences"] = "包含偏好设定"
	L["Include Notes"] = "包含备注"
	L["Press Ctrl+V to paste a team from the clipboard."] = "按 Ctrl+V 粘贴队伍"
	L["This is not a recognizable team."] = "无法识别该队伍"
	L["An existing team already has this %s."] = "已经有队伍使用这个 %s"
	L["target"] = "目标"
	L["name"] = "名称"
	L["Create a new copy"] = "创建新的复制"
	L["Overwrite existing team"] = "覆盖已有的队伍"
	L["%s%d\124r teams are in this import."] = "此次导入 %s%d\124r 个队伍"
	L["%s%d\124r have a name or target already used."] = "%s%d\124r 已有名称或目标已经被使用"
	L["Create new copies"] = "创建新的复制"
	L["Overwrite existing teams"] = "覆盖已有的队伍"
	L["Send"] = "发送"
	L["Who do you want to send this team to?"] = "要将队伍发送给谁?"
	L["Sending..."] = "正在发送..."
	L["No response. Lag or they don't have Rematch?"] = "没有回应，网路延迟或对方没有使用 Rematch ?"
	L["Team successfully received!"] = "已经成功的接收队伍!"
	L["Sending...%d%%"] = "正在发送...%d%%"
	L["They're busy. Try again later."] = "对方忙碌中，请稍后再试"
	L["They're in combat. Try again later."] = "对方对战中，请稍后再试"
	L["They have team sharing disabled."] = "对方禁用共享功能"
	L["Incoming Rematch Team!"] = "有人给你发送了一个队伍!"
	L["%s%s\124r has sent you a team named \"%s\" (for %s)."] = "%s%s\124r 发送给你一个队伍，名为 \"%s\" (目标是 %s)"
	L["%s%s\124r has sent you a team for %s."] = "%s%s\124r 发送给你一个队伍，目标是 %s"
	L["%s%s\124r has sent you a team named \"%s\"."] = "%s%s\124r 发送给你一个队伍，名为 \"%s\""
	L["Import these teams?"] = "是否要导入队伍?"
	L["Import"] = "导入"
	L["%s%d\124r Rematch teams have the same name."] = "%s%d\124r  Rematch 中已经有相同的队伍名"
	L["Please Wait..."] = "请稍等..."
	L["Press Ctrl+C to copy these teams to the clipboard. Then paste them into an email to yourself or a text file someplace safe.\n\nIf you ever need to restore your teams, paste them back in with Import Teams."] = "按 Ctrl+C 复制这些队伍，然后粘贴到邮件里发给你自己，或者粘贴到一个纯文本文件里。\n\n如果需要恢复你的队伍，把它们粘贴在导入队伍选项里"

-- Dialogs\Tooltip.lua

-- Dialogs\ScriptFilter.lua
	L["Pet Variables"] = "宠物变量"
	L["Exposed API"] = "公开API"
	L["Test"] = "测试"
	L["line "] = "行"
	L["Pet Filter Script Error"] = "宠物筛选方式脚本程序发生错误"
	L["Error in %s"] = "发生错误于 %s"
	L["\124TInterface\\RaidFrame\\ReadyCheck-NotReady:16\124t Error %s"] = "\124TInterface\\RaidFrame\\ReadyCheck-NotReady:16\124t 错误 %s"
	L["\124TInterface\\RaidFrame\\ReadyCheck-Ready:16\124t Script ran without errors!"] = "\124TInterface\\RaidFrame\\ReadyCheck-Ready:16\124t 脚本运行成功!"

-- Dialogs\Collection.lua
	L["Total Collected Pets"] = "全部收集的宠物"
	L["Unique Collected Pets"] = "收集的独特宠物"
	L["Pets Not Collected"] = "尚未收集的宠物"
	L["Percent Collected"] = "收集百分比"
	L["Max Level Pets"] = "满级的宠物"
	L["Rare Quality Pets"] = "精良属性宠物"
	L["Unique Pets In The Game"] = "游戏中的独特宠物"
	L["Collection Statistics"] = "收藏统计"
	L["There are %s%d\124r unique pets in the game."] = "游戏中的独特宠物有 %s%d\124r 个"
	L["Pets Collected"] = "已收集的宠物"
	L["Pets At Max Level"] = "满级的宠物"
	L["Total"] = "全部"
	L["Unique"] = "独特"
	L["Duplicate Collected Pets"] = "重复收集的宠物"
	L["Average Battle Pet Level"] = "战斗宠物平均等级"
	L["You have %s%.1f%%\124r of all unique pets."] = "全部的独特宠物中，你有 %s%.1f%%\124r"
	L["All unique pets in the game."] = "游戏中的所有独特宠物"
	L["All pets you've collected, including duplicates."] = "你所收集的所有宠物，包含重复的"
	L["The unique pets you've collected, not including duplicates."] = "你所收集的独特宠物，不包含重复的"
	L["The unique pets you're missing."] = "你还没有的独特宠物"
	L["How much of each category's unique pets you've collected as a percent."] = "你在每个类别所收集的独特宠物百分比"
	L["All of your level 25 pets, including duplicates."] = "所有25级的宠物，包含重复的"
	L["All of your rare quality pets, including duplicates."] = "所有精良属性的宠物，包含重复的"
	L["Pet Types"] = "宠物类型"
	L["Sources"] = "来源"

-- Frames\Frame.lua
	L["Pets"] = "宠物"
	L["Options"] = "选项"
	L["Toggle Single Panel Mode"] = "开启/关闭单一窗口模式"
	L["Toggle between one panel or two panels side by side."] = "在单一面板和双面板之间作切换"
	L["You are in combat. Try again when out of combat."] = "正在战斗中，请脱离战斗后重试。"

-- Frames\Configure.lua

-- Frames\Journal.lua
	L["Enable Rematch"] = "启用 Rematch"
	L["Check this to use Rematch in the pet journal."] = "启用这个选项，在系统默认的宠物界面中使用 Rematch"

-- Frames\Battle.lua

-- Process\Battle.lua
	L["Show Pet Card"] = "显示宠物卡"

-- Process\Breeds.lua

end
